var VideoBox = function(parent, config) {
    var box = this;
    
    this.elements = config.elements;
    this.names = config.names;
    
    this.selectorGroup = document.createElement("div"); 
    this.selectorGroup.className = "selector-group";
    
    this.selectors = [];
    for (var i = 0; i < this.elements.length; i++) {
        var selector = document.createElement("div");
        selector.className = "selector selector-primary";
        if (i == 0)
            selector.className += " active";
        selector.appendChild(document.createTextNode(this.names[i]));
        
        selector.addEventListener("mouseover", function(idx, event) {
            this.selectImage(idx);
        }.bind(this, i));
        
        this.selectors.push(selector);
        this.selectorGroup.appendChild(selector);
    }
    
    var title = document.createElement("h1"); 
    title.className = "image-box-title";
    title.appendChild(document.createTextNode(config.title));

    this.display = document.createElement("video"); 
    this.display.src = this.elements[0];
    this.display.className = "image-display";
    this.display.autoplay = true;
    this.display.loop = true;
    this.display.muted = true;
    this.display.width = 1280;
    this.display.height = 720;
    
    this.containerDiv = document.createElement("div"); 
    this.containerDiv.className = "image-box";
    this.containerDiv.appendChild(title);
    this.containerDiv.appendChild(document.createElement("hr"));
    this.containerDiv.appendChild(this.selectorGroup);
    this.containerDiv.appendChild(this.display);

    document.addEventListener("keypress", function(event) { box.keyPressHandler(event); });
    parent.appendChild(this.containerDiv);
}

VideoBox.prototype.selectImage = function(idx) {
    for (var i = 0; i < this.elements.length; i++) {
        if (i == idx)
            this.selectors[i].className += " active";
        else
            this.selectors[i].className = this.selectors[i].className.replace( /(?:^|\s)active(?!\S)/g , '');
    }
    this.display.src = this.elements[idx];
}

VideoBox.prototype.keyPressHandler = function(event) {
    var idx = parseInt(event.charCode) - "1".charCodeAt(0);
    if (idx >= 0 && idx < this.elements.length)
        this.selectImage(idx);
}
