var VideoBox = function(parent, config) {
    var box = this;
    
    this.elements = config.elements;
    this.names = config.names;
    this.labelPadding = 15;
    
    var padHorz = this.labelPadding + 'px';
    var padVert = (this.labelPadding - 5) + 'px';
    
    var title = document.createElement("h1"); 
    title.className = "video-box-title";
    title.appendChild(document.createTextNode(config.title));
    
    var videos = [];
    var labels = [];
    for (var i = 0; i < 2; ++i) {
        var video = document.createElement("video");
        video.src = this.elements[i];
        video.autoplay = true;
        video.loop = true;
        
        var label = document.createElement("div");
        label.className = "video-label";
        label.style.bottom = padVert;
        if (i == 0)
            label.style.left  = padHorz;
        else
            label.style.right = padHorz;
        label.appendChild(document.createTextNode(this.names[i]));
        
        videos.push(video);
        labels.push(label);
    }
    
    this.overlayDiv = document.createElement("div");
    this.overlayDiv.className = 'video-overlay';
    this.overlayDiv.appendChild(videos[0]);
    this.overlayDiv.appendChild(labels[0]);
    
    this.labelLeft = labels[0];
    
    this.separator = document.createElement('div');
    this.separator.className = 'video-separator';
    var separatorDiv = document.createElement('div');
    separatorDiv.className = 'video-separator-bar';
    this.separator.appendChild(separatorDiv);

    this.videoDisplay = document.createElement("div");
    this.videoDisplay.className = 'video-display';
    this.videoDisplay.appendChild(videos[1]);
    this.videoDisplay.appendChild(labels[1]);
    this.videoDisplay.appendChild(this.overlayDiv);
    this.videoDisplay.appendChild(this.separator);
    this.videoDisplay.addEventListener('mousemove', this.mouseMoveHandler.bind(this));
    
    this.containerDiv = document.createElement("div"); 
    this.containerDiv.className = "video-box";
    this.containerDiv.appendChild(title);
    this.containerDiv.appendChild(document.createElement("hr"));
    this.containerDiv.appendChild(this.videoDisplay);
    
    var setWidth = (function(w) {
        this.videoDisplay.style.maxWidth = w + 'px';
        this.setSeparator(w/2);
    }).bind(this);
    
    if (videos[0].videoWidth == 0)
        videos[0].addEventListener('loadedmetadata', (function() {setWidth(videos[0].videoWidth);}).bind(this));
    else
        setWidth(videos[0].videoWidth);
    
    parent.appendChild(this.containerDiv);
}

VideoBox.prototype.setSeparator = function(xCoord) {
    this.overlayDiv.style.width = xCoord + 'px';
    this.labelLeft.style.width = (xCoord - this.labelPadding) + 'px';
    this.separator.style.left = (xCoord - 11) + 'px';
}

VideoBox.prototype.mouseMoveHandler = function(event) {
    var rect = this.videoDisplay.getBoundingClientRect();
    var xCoord = Math.floor((event.clientX - rect.left));
    var yCoord = Math.floor((event.clientY - rect.top ));
    
    xCoord = Math.max(0, Math.min(xCoord, rect.right - rect.left));
    
    this.setSeparator(xCoord);
}
