#pragma once
#include <G3D/G3DAll.h>
#include "BilateralFilter2.h"
#include "TemporalFilter2.h"
class GIRenderer : public DefaultRenderer {
protected:
    /** Used by renderIndirectIllumination(). Member variables to avoid re-allocation per frame.*/
    Array<Ray>                  m_matteRay, m_glossyRay;

    /** Used by renderIndirectIllumination(). Member variables to avoid re-allocation per frame.*/
    Array<float>                m_glossyWeight;

    /** Path traced samples, one per pixel, in R11G11B10F format */
    shared_ptr<Texture>         m_rawMatteIndirect;

    /** Path traced samples, one per pixel, in RGBA32F format, with distance to hits in the A channel */
    shared_ptr<Texture>         m_rawGlossyIndirect;

    TemporalFilter2::Settings   m_matteTemporalFilterSettings;
    TemporalFilter2::Settings   m_glossyTemporalFilterSettings;

    BilateralFilterSettings2    m_matteSpatialPreFilterSettings;
    BilateralFilterSettings2    m_matteSpatialFilterSettings;
    BilateralFilterSettings2    m_glossySpatialFilterSettings;

    shared_ptr<Framebuffer>     m_matteMedianFilterOutputFramebuffer;

    shared_ptr<Framebuffer>     m_matteSpatialPrefilterOutputFramebuffer;
    shared_ptr<Texture>         m_matteSpatialPrefilterInputTexture;

    shared_ptr<Texture>         m_matteTemporalWeightBuffer;
    shared_ptr<Texture>         m_glossyTemporalWeightBuffer;


    shared_ptr<Framebuffer>     m_weightDilationFramebuffer;
    shared_ptr<Texture>         m_matteTemporalWeightHBlurBuffer;
    shared_ptr<Texture>         m_glossyTemporalWeightHBlurBuffer;

    shared_ptr<Texture>         m_matteTemporalWeightFilteredBuffer;
    shared_ptr<Texture>         m_glossyTemporalWeightFilteredBuffer;

    TemporalFilter2             m_matteTemporalFilter;
    TemporalFilter2             m_glossyTemporalFilter;

    BilateralFilter2            m_matteSpatialPreFilter;
    BilateralFilter2            m_matteSpatialFilter;
    BilateralFilter2            m_glossySpatialFilter;

    shared_ptr<Framebuffer>     m_filteredMatteIndirectFramebuffer;
    shared_ptr<Framebuffer>     m_filteredGlossyIndirectFramebuffer;

    shared_ptr<PathTracer>      m_pathTracer;

    /**
     Computed in computeIndirect()

     Attachments:
      - 0: World-space ray origin, rgb32f
      - 1: World-space matte ray direction, rgb16f
      - 2: World-space glossy ray direction and weight, rgba16f
     */
    shared_ptr<Framebuffer>     m_rayFramebuffer;
        
    virtual void setDeferredShadingArgs
       (Args&                               args, 
        const shared_ptr<GBuffer>&          gbuffer, 
        const LightingEnvironment&          environment) override;
    
    GIRenderer();

    /** Called from renderIndirectIllumination */
    virtual void generateIndirectRays(RenderDevice* rd,const shared_ptr<GBuffer>& gbuffer, const shared_ptr<Framebuffer>& rayFramebuffer);

    /** Called from renderIndirectIllumination */
    virtual void copyIndirectRaysToCPU(const shared_ptr<Framebuffer>& rayFramebuffer, Array<Ray>& matteRay, Array<Ray>& glossyRay, Array<float>& glossyWeight);

    /** Called from renderIndirectIllumination.
        glossyLightPTB contains distance to the secondary hit (from the primary hit) in the A channel.
    */
    virtual void traceIndirectRays(int w, int h, const Array<Ray>& matteRay, const Array<Ray>& glossyRay, const Array<float>& glossyWeight, shared_ptr<GLPixelTransferBuffer>& matteLightPTB, shared_ptr<GLPixelTransferBuffer>& glossyLightPTB);

    virtual void copyIndirectLightToGPU(
        const shared_ptr<Texture>&                  matteLightTexture,
        const shared_ptr<GLPixelTransferBuffer>&    matteLightPTB, 
        const shared_ptr<Texture>&                  glossyLightTexture,
        const shared_ptr<GLPixelTransferBuffer>&    glossyLightPTB);

    /** Called from renderIndirectIllumination */
    virtual void denoiseIndirectIllumination(RenderDevice* rd, const shared_ptr<GBuffer>& gbuffer);

public:

    static shared_ptr<Renderer> create() {
        return createShared<GIRenderer>();
    }

    virtual void renderIndirectIllumination
       (RenderDevice*                       rd,
        const shared_ptr<GBuffer>&          gbuffer,
        const LightingEnvironment&          environment) override;

    //---------------------Debugging/research features exposed below here------------------------

    virtual void onSceneLoad(const shared_ptr<Scene>& scene);

    // Call every frame. This is to allow easy GUI construction, leaving these settings on App.
    void updateFilterSettings
    (const BilateralFilterSettings2&  matteSpatialPreSettings,
     const BilateralFilterSettings2&  matteSpatialSettings,
     const BilateralFilterSettings2&  glossySpatialSettings,
     const TemporalFilter2::Settings& matteTemporalSettings,
     const TemporalFilter2::Settings& glossyTemporalSettings);

    PathTracer::Options     pathTraceOptions;

    bool                    filteringEnabled    = true;
    bool                    enableGI            = true;

    /** If false, do not re-trace the rays. Used when debugging to avoid the slow trace step. */
    bool                    updateTracedRays    = true;                            
    Irradiance3             averageMatteValue   = Irradiance3(0.0f, 0.0f, 0.0f);
    Radiance3               averageGlossyValue  = Radiance3(0.0f, 0.0f, 0.0f);
                            
    bool                    updateAverageValues = false;
    bool                    useMedianPreSpatialMatte = false;
};
