/**
  \file App.h
 */
#pragma once
#include <G3D/G3DAll.h>

#include "TemporalFilter2.h"
#include "BilateralFilter2.h"
/** \brief Application framework. */
class App : public GApp {
protected:

    enum RenderRate {
        MANUAL,
        INTERMITTENT,
        CONTINUOUS
    };

    RenderRate      m_renderRate = MANUAL;

    /** Used for controlling the rate of the renderer updating when it is very slow.*/
    bool            m_update3DImage;

    float           m_exportSampleRateOneDimension = 4.0f;

    int             m_framesToConvergenceForExportResults = 1;

    BilateralFilterSettings2     m_matteSpatialPreFilterSettings;

    TemporalFilter2::Settings    m_matteTemporalFilterSettings;
    TemporalFilter2::Settings    m_glossyTemporalFilterSettings;

    BilateralFilterSettings2     m_matteSpatialFilterSettings;
    BilateralFilterSettings2     m_glossySpatialFilterSettings;

    /** Called from onInit */
    void makeGUI();

public:

    App(const GApp::Settings& settings = GApp::Settings());
    virtual void onInit() override;
    virtual void onGraphics3D(RenderDevice* rd, Array<shared_ptr<Surface> >& allSurfaces) override;    
    virtual bool onEvent(const GEvent& event) override;
    virtual void onAfterLoadScene(const Any &any, const String &sceneName) override;
    void onExportBuffers();
    void onExportResults();

    void exportAllResults();
};
